------------------------------------------------------------------------------
-- IUP Bin Administrator
--
-- $Revision$
--
-- Uses the IUP interface creation toolkit to admin the bins.
--
-- written by : Sean Konrad (sean@eyeonline.com)
--              January 12th, 2005
------------------------------------------------------------------------------


-- First, we need to log in with administrative priveleges.  If the user doesn't have administrative priveleges, 
-- they shouldn't be allowed to manipulate the user lists.

-------------------------------------------------
-- Let's make a log in interface!
-------------------------------------------------

txtServer = iup.text{SIZE = "80", VALUE = "localhost"}
txtLibrary = iup.text{SIZE = "80", VALUE = "Library"}
txtUserLogin = iup.text{SIZE = "80", VALUE = "Administrator"}
txtPasswordLogin = iup.text{SIZE = "80"}
btnLogin = iup.button{title = "Log In", size = "40"}
btnCancelLog = iup.button{title = "Cancel", size = "40"}

vboxLog = iup.vbox
{
	iup.label{title = "Server"},
	txtServer,
	iup.label{title = "Library"},
	txtLibrary,
	iup.label{title="Username"},
	txtUserLogin,
	iup.label {title="Password"},
	txtPasswordLogin,
	iup.fill{},
	iup.hbox{btnLogin,btnCancelLog, MARGIN = "0"}
}

dlg_login=iup.dialog
	{	
	vboxLog,
	title="Login", menu=mnu, SIZE="100x110", BGCOLOR="50 50 50", FGCOLOR = "200 200 200", TOPMOST = "NO", FONT = "ARIAL::", RESIZE = "NO", MAXBOX = "NO", MARGIN = "10x10"
	}
	
function btnCancelLog:action()
	print("Cancelled!") return
	iup.Hide(dlg_login)
end

function btnLogin:action()
	ret = {}
	ret.HostName = txtServer.value
	ret.Library = txtLibrary.value
	ret.UserName = txtUserLogin.value
	ret.PasswordLogin = txtPasswordLogin.value
	iup.Hide(dlg_login)
end


dlg_login:showxy(iup.CENTER, iup.CENTER)
iup.MainLoop()


if ret == nil then return end

-- connect to es..
es = FusionServer ( ret.HostName, 10)

-- can't connect?
if not es then  iup.Alarm("Script Failed", "Unable to connect to host.  Check your host name and try again.", "OK") do return end end

local lib = nil

while not lib do
	-- connect to the library
	lib,err = es:OpenLibrary(ret.Library, ret.UserName, ret.Password)
	
	if not lib then
		if err == "Unknown Library" then
			if iup.Alarm("Unknown Library", "Unknown Library '" .. ret.Library .. "' - Would you like to create it?", "Yes", "No") == 1 then
				lib,err = es:CreateLibrary(ret.Library)
				
				if not lib then
					iup.Alarm("Script Failed", "Unable to create library: " .. err, "OK")
					return
				end
				
				lib = nil
				
			else
				return
			end
			
		else
			iup.Alarm("Script Failed", "Unable to open library: " .. err, "OK")
			
			return
		end
	end
end

if lib:GetUser(ret.UserName).Permissions.Admin == false then print("Script Failed: User does not have administrator priveleges.") do return end end

dropDown = iup.list{SIZE = "150x100"}
txtUser = iup.text{value = "", SIZE = "80",FGCOLOR = "200 200 200", MARGIN="15"}
txtPassword = iup.text{value = "", SIZE = "80",FGCOLOR = "200 200 200", MARGIN="15"}
toggleDelete = iup.toggle{title = "Delete" }
toggleAdmin = iup.toggle{title = "Admin"}
toggleRead = iup.toggle{title = "Read"}
toggleCreate = iup.toggle{title = "Create"}
toggleModify = iup.toggle{title = "Modify"}
btn_Set = iup.button{title = "Set", size = 20}
btn_Add = iup.button{title = "+", size = 20}
btn_Remove = iup.button{title = "-", size = 20}
btn_OKUser = iup.button { title = "OK", size =80, FLAT="YES", FGCOLOR = "200 200 200", MARGIN = "47"}
btn_CancelUser = iup.button { title = "Cancel", size =80, FLAT="YES", FGCOLOR = "200 200 200", MARGIN ="47"}
textUserAdd = iup.text{value = "", SIZE = "200",FGCOLOR = "200 200 200", MARGIN="15"}





---------------------------------------------------


-- interface for the add user button..
vboxUser =   iup.vbox
  {
    iup.hbox
    {
        iup.hbox
        {
		  iup.label{title = "Username", FGCOLOR = "200 200 200"},
		  textUserAdd,
		  SIZE = "270", MARGIN = "10", GAP = "10"
        }
	  ,
    GAP = "", MARGIN = "10"
	},
	iup.vbox{iup.fill{SIZE = "5"};SIZE = "5"},
	iup.vbox
    {
                     
        iup.hbox
        {
		btn_OKUser,
		btn_CancelUser
		; ALIGNMENT="ACENTER"
        }
        ;title="", SIZE = "180x30", ALIGNMENT = "ACENTER", FGCOLOR = "70 70 70", GAP = "50"
	;ALIGNMENT = "ACENTER", MARGIN = "35"}
  ;MARGIN = "5x5"
  }
  
-----------------------------------------------
-- Function for filling the dropdown menu.
function fill_dropDown()
	
	-- clear the list...
	counter = 0
	if userList then 
		for i, v in pairs(userList) do
			counter = counter+1
			dropDown[tostring(counter)]=nil
		end
	end
	userList = nil
	userList = lib:GetUserList()
	txtUserList = nil
	txtUserList = {}
	counter = 0
	for i, user in pairs(userList) do
		counter = counter + 1
		txtUserList[counter] = i
		dropDown[tostring(counter)] = i
	end
end

-- call it.
fill_dropDown()


-- set up the interface...
hbox1 = iup.hbox{
			iup.vbox{iup.label{title = "User List\n"}, iup.fill{}, dropDown}
			,iup.fill{}
			,iup.vbox{
				iup.label{title = "Username"},
				txtUser,
				iup.fill{},
				iup.label{title = "Password"},
				txtPassword,
				iup.fill{},
				toggleDelete,
				iup.fill{},
				toggleAdmin,
				iup.fill{},
				toggleRead,
				iup.fill{},
				toggleCreate,
				iup.fill{},
				toggleModify}, 
			iup.fill{}, 
			iup.vbox{
				btn_Set,
				iup.fill{},
				btn_Add, 
				iup.fill{}, 
				btn_Remove}
			}
----------------------------------------------------------------
-- define actions for changing values in ye olde dropdown
----------------------------------------------------------------

function dropDown:action()
	local settingList = lib:GetUser(txtUserList[tonumber(dropDown.value)])
	txtUser.value = txtUserList[tonumber(dropDown.value)]
	txtPassword.value = settingList.Password
	if settingList.Permissions.Delete == true then toggleDelete.VALUE = "ON"  else toggleDelete.Value = "OFF" end
	if settingList.Permissions.Admin == true then toggleAdmin.VALUE = "ON" else toggleAdmin.Value = "OFF" end
	if settingList.Permissions.Read == true then toggleRead.VALUE = "ON" else toggleRead.Value = "OFF" end
	if settingList.Permissions.Create == true then toggleCreate.VALUE = "ON" else toggleCreate.Value = "OFF" end
	if settingList.Permissions.Modify == true then toggleModify.VALUE = "ON" else toggleModify.Value = "OFF" end
end

----------------------------------------------------------------
-- define actions for changing values in ye olde Set Button
----------------------------------------------------------------

function btn_Set:action()
	if dropDown.value then
		settingList = nil
		settingList = {}
		settingList.Permissions = {}
		settingList.Password = txtPassword.value
		
		if toggleDelete.value == "ON" then settingList.Permissions.Delete = true end
		if toggleAdmin.value == "ON" then settingList.Permissions.Admin = true end
		if toggleModify.value == "ON" then settingList.Permissions.Modify = true end
		if toggleCreate.value == "ON" then settingList.Permissions.Create = true end
		if toggleRead.value == "ON" then settingList.Permissions.Read = true end
		lib:ModifyUser(txtUserList[tonumber(dropDown.value)], settingList)
	end
end

----------------------------------------------------------------
-- define actions for changing values in ye olde Add button
----------------------------------------------------------------


function addUser()	
	-- We need to show the dialog to add the slave -- we've already defined the elements for it above.
	dlg_useradd=iup.dialog
	{	
	vboxUser
	;title="Enter the User's name; manipulate from main dialog.", menu=mnu, SIZE="315x55", BGCOLOR="50 50 50", FGCOLOR = "200 200 200", TOPMOST = "NO", FONT = "ARIAL::", RESIZE = "NO", MAXBOX = "NO"
	}
end


-- The action for the btn_addUser button..
function btn_Add:action()
	-- Calls the already declared "addUser() function 
	addUser()
	-- Shows the dialog that's been created for the user add..
	dlg_useradd:showxy(iup.CENTER, iup.CENTER)
	iup.MainLoop{}
end

-- Action for the OK button..
function btn_OKUser:action()
	local tempTable = {}
	tempTable.Permissions = {Admin = false, Modify = false, Create = false, Read = false, Delete = false}
	tempTable.Password = ""
	lib:ModifyUser(textUserAdd.Value, tempTable)
	textUserAdd.value = ""
	-- Hide the interface.
	iup.Hide(dlg_useradd)
	fill_dropDown()
end

-- Button for the cancel option..
function btn_CancelUser:action()
	textUserAdd.value = ""
	-- Hide the dialog.
	iup.Hide(dlg_useradd)
	-- REFRESH
	fill_dropDown()
end
----------------------------------------------------------------
-- define actions for changing values in ye olde Remove Button
----------------------------------------------------------------
function btn_Remove:action()
	if iup.Alarm("Warning", "Do you really want to delete the " .. txtUserList[tonumber(dropDown.value)] .. " account?", "Yes", "Cancel") == 1 then
		if userList then
			lib:ModifyUser(txtUserList[tonumber(dropDown.value)], nil)
			fill_dropDown()
		end
		txtUser.value = ""
		txtPassword.value = ""
		toggleDelete.value ="OFF"
		toggleAdmin.value = "OFF"
		toggleModify.value = "OFF"
		toggleCreate.value  = "OFF"
		toggleRead.value = "OFF"
	end
end


-- show the dialog.
dlg = iup.dialog{hbox1, MARGIN= "20x20", TOPMOST = "NO",  BGCOLOR="50 50 50", FGCOLOR = "200 200 200", RESIZE = "NO", TITLE = "Remote Bin Admin"}


dlg:showxy(iup.CENTER, iup.CENTER)
iup.MainLoop()
